/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.gelato_galore.reload;

import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.itayfeder.gelato_galore.networking.SyncFlavorDataMessage;
import com.itayfeder.gelato_galore.reload.FlavorData;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class FlavorDataReloadListener
extends SimpleJsonResourceReloadListener {
    public static final FlavorDataReloadListener INSTANCE;
    public static final Gson GSON;
    public static final HashBiMap<ResourceLocation, FlavorData> FLAVOR_MAP;

    public FlavorDataReloadListener() {
        super(GSON, "gelato_galore/flavors");
    }

    public static Map<ResourceLocation, FlavorData> getSidedMap() {
        if (EffectiveSide.get().isServer()) {
            return FLAVOR_MAP;
        }
        return SyncFlavorDataMessage.CLIENT_FLAVORS_MAP;
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        FLAVOR_MAP.clear();
        FlavorData.CURRENT_MAX_ID = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation name = entry.getKey();
            String[] split = name.m_135815_().split("/");
            if (split[split.length - 1].startsWith("_")) continue;
            JsonObject json = entry.getValue().getAsJsonObject();
            try {
                FlavorData flavor = FlavorData.deserialize(json, name);
                if (flavor == null) continue;
                FLAVOR_MAP.put((Object)name, (Object)flavor);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                System.out.println(String.format("I got an error!!!: ", e));
            }
        }
        System.out.println(String.format("%s Flavors loaded successfully !", FLAVOR_MAP.size()));
        for (Map.Entry<Object, Object> entry : FLAVOR_MAP.entrySet()) {
            System.out.println(String.format(entry.getKey() + " ==> " + entry.getValue(), new Object[0]));
        }
    }

    static {
        GSON = new GsonBuilder().create();
        FLAVOR_MAP = HashBiMap.create();
        INSTANCE = new FlavorDataReloadListener();
    }
}

